<?php include __DIR__.'/head.php'; ?>
<section class="p-3">
  <h4 class="fw-bold text-center mb-3">Unggah Dokumen Pendukung</h4>
  <form id="formUpload" class="vstack gap-3" enctype="multipart/form-data">
    <input type="hidden" name="id_surat" id="id_surat">
    <div class="card p-3">
      <label class="form-label">Upload KTP (jpg/png/pdf)</label>
      <input class="form-control" type="file" name="ktp" accept=".jpg,.jpeg,.png,.pdf" required>
    </div>
    <div class="card p-3">
      <label class="form-label">Foto Selfie (jpg/png)</label>
      <input class="form-control" type="file" name="selfie" accept=".jpg,.jpeg,.png" required>
    </div>
    <button class="btn btn-warning btn-lg fw-bold rounded-pill">Selesai</button>
  </form>
</section>
<script>
const id = sessionStorage.getItem('last_surat_id');
document.getElementById('id_surat').value = id || '';
document.getElementById('formUpload').addEventListener('submit', async (e) => {
  e.preventDefault();
  const fd = new FormData(e.target);
  const res = await fetch('../api/upload_dokumen.php', { method:'POST', body: fd });
  const j = await res.json();
  if (j.success) {
    alert('Pengajuan terkirim!');
    location.href = 'index.php';
  } else {
    alert(j.message || 'Upload gagal.');
  }
});
</script>
<?php include __DIR__.'/nav.php'; ?>
<?php include __DIR__.'/foot.php'; ?>
