<?php include __DIR__.'/head.php'; ?>
<section class="p-3">
  <h4 class="fw-bold text-center mb-3">Formulir Data Surat</h4>
  <form id="formSurat" class="vstack gap-3">
    <select name="jenis_surat" class="form-select form-select-lg" required>
      <option value="">Pilih Jenis Surat</option>
      <option>Surat Keterangan Domisili</option>
      <option>Surat Keterangan Usaha</option>
      <option>Surat Pengantar RT/RW</option>
      <option>Surat Keterangan Tidak Mampu</option>
    </select>
    <input class="form-control form-control-lg" name="nama_lengkap" placeholder="Nama Lengkap" required>
    <input class="form-control form-control-lg" name="nik" placeholder="NIK" required>
    <input class="form-control form-control-lg" name="ttl" placeholder="Tempat Tanggal Lahir" required>
    <select class="form-select form-select-lg" name="jenis_kelamin" required>
      <option value="">Jenis Kelamin</option>
      <option value="L">Laki-laki</option>
      <option value="P">Perempuan</option>
    </select>
    <textarea class="form-control form-control-lg" name="alamat" placeholder="Alamat Lengkap" rows="2" required></textarea>
    <input class="form-control form-control-lg" name="kontak" placeholder="Nomor HP / Email" required>
    <select class="form-select form-select-lg" name="jenis_file" required>
      <option value="">Jenis Fail Surat</option>
      <option>PDF</option>
      <option>DOCX</option>
    </select>
    <button class="btn btn-warning btn-lg fw-bold rounded-pill">Selanjutnya</button>
  </form>
</section>
<script>
document.getElementById('formSurat').addEventListener('submit', async (e) => {
  e.preventDefault();
  const fd = new FormData(e.target);
  const payload = Object.fromEntries(fd.entries());
  const res = await fetch('../api/submit_surat.php', {
    method:'POST',
    headers:{'Content-Type':'application/json'},
    body: JSON.stringify(payload)
  });
  const j = await res.json();
  if (j.success) {
    sessionStorage.setItem('last_surat_id', j.id_surat);
    location.href = 'upload_dokumen.php';
  } else {
    alert(j.message || 'Gagal menyimpan.');
  }
});
</script>
<?php include __DIR__.'/nav.php'; ?>
<?php include __DIR__.'/foot.php'; ?>
