<?php require_once __DIR__.'/../../config.php'; session_start();
if(isset($_SESSION['wid'])){ header('Location: ../index.php'); exit; }
$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $nik = $_POST['nik'] ?? ''; $nama = $_POST['nama'] ?? ''; $pass = $_POST['password'] ?? '';
  try{
    $hash = password_hash($pass, PASSWORD_BCRYPT);
    $stmt = $mysqli->prepare("INSERT INTO warga (nik, nama_lengkap, password) VALUES (?,?,?)");
    $stmt->bind_param("sss", $nik, $nama, $hash);
    $stmt->execute();
    $ok = 'Pendaftaran berhasil. Silakan masuk.';
  }catch(Throwable $e){ $err='Gagal: kemungkinan NIK sudah terdaftar.'; }
}
?>
<!doctype html><html lang="id"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"><title>Daftar</title></head>
<body class="bg-light">
<div class="container py-4" style="max-width:480px">
  <a href="../index.php" class="btn btn-link">&larr; Beranda</a>
  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="fw-bold mb-3 text-center">Daftar Akun Warga</h5>
      <?php if($err) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
      <?php if($ok) echo '<div class="alert alert-success">'.$ok.'</div>'; ?>
      <form method="post">
        <div class="mb-2"><label class="form-label">NIK</label><input class="form-control" name="nik" required></div>
        <div class="mb-2"><label class="form-label">Nama Lengkap</label><input class="form-control" name="nama" required></div>
        <div class="mb-3"><label class="form-label">Password</label><input class="form-control" type="password" name="password" required></div>
        <button class="btn btn-success w-100">Daftar</button>
      </form>
      <hr>
      <div class="text-center small">Sudah punya akun? <a href="login.php">Masuk</a></div>
    </div>
  </div>
</div>
</body></html>
