document.addEventListener('DOMContentLoaded', async () => {
  const el = document.getElementById('beritaList');
  if(!el) return;
  try{
    const res = await fetch('../api/get_berita.php');
    const j = await res.json();
    j.items.forEach(b=>{
      const card = document.createElement('div');
      card.className = 'card border-0 shadow-sm';
      card.innerHTML = `<div class="card-body"><h6 class="fw-bold">${b.judul}</h6><div class="text-muted small">${b.tanggal}</div><p class="m-0">${b.ringkas}</p></div>`;
      el.appendChild(card);
    });
  }catch(e){ el.innerHTML = '<em>Tidak ada berita.</em>'; }
});

(async ()=>{
  const elg = document.getElementById('galeriList');
  if(!elg) return;
  try{
    const res = await fetch('../api/get_galeri.php');
    const j = await res.json();
    j.items.forEach(g=>{
      const col = document.createElement('div'); col.className='col-6 col-md-3';
      col.innerHTML = `<div class="card border-0 shadow-sm"><img src="uploads/${g.file.split('uploads/')[1]}" class="card-img-top" alt=""><div class="card-body p-2"><div class="small fw-bold text-truncate">${g.judul}</div></div></div>`;
      elg.appendChild(col);
    });
  }catch(e){ /* ignore */ }
})();
